function [res,accuracy] = prec_recall(resdata)
%takes as argumens a n*4 matrix containing each group as row and each row
%contains in the following order [tp,tn,fp,fn]
%it the returns a row of precision,recall,f1 for each group and one fr the total, aka (n+1)*3
%matrix.
%resdata=[resdata;sum(resdata,1)];
warning off;
prec = resdata(:,1) ./sum(resdata(:,[1,3]),2); % =tp/(tp+fp);
recall = resdata(:,1) ./sum(resdata(:,[1,4]),2); % =tp/(tp+fn);
f1= 2*(prec.*recall)./(prec+recall);
accuracy =sum(resdata(:,1))/sum(resdata(1,:)); %divding by total number of dokuments, arbitrary row will do.

res=[prec,recall,f1];
warning on;